#include "SimpleSerialAnalyzerSettings.h"
#include <AnalyzerHelpers.h>


void SimpleSerialAnalyzerSettings::ClaimChannels(void)
{
	ClearChannels();
	AddChannel( mChannelPin1, "MAPLE_p1", mChannelPin1 != UNDEFINED_CHANNEL );
	AddChannel( mChannelPin5, "MAPLE_p5", mChannelPin5 != UNDEFINED_CHANNEL );
}

SimpleSerialAnalyzerSettings::SimpleSerialAnalyzerSettings()
:	mChannelPin1( UNDEFINED_CHANNEL ),
	mChannelPin5( UNDEFINED_CHANNEL ),
	mDisplayMode( DISPLAY_MODE_TRANSACTIONS )
{
	mChannelPin1Iface.reset( new AnalyzerSettingInterfaceChannel() );
	mChannelPin1Iface->SetTitleAndTooltip( "MAPLE Pin 1", "What would be pin 1 on the dreamcast controller interface" );
	mChannelPin1Iface->SetChannel( mChannelPin1 );
	mChannelPin1Iface->SetSelectionOfNoneIsAllowed(false);

	mChannelPin5Iface.reset( new AnalyzerSettingInterfaceChannel() );
	mChannelPin5Iface->SetTitleAndTooltip( "MAPLE Pin 5", "What would be pin 5 on the dreamcast controller interface" );
	mChannelPin5Iface->SetChannel( mChannelPin5 );
	mChannelPin1Iface->SetSelectionOfNoneIsAllowed(false);

	mDisplayModeIface.reset( new AnalyzerSettingInterfaceNumberList() );
	mDisplayModeIface->SetTitleAndTooltip("Display Mode", "What level of protocol to display");
	mDisplayModeIface->ClearNumbers();
	mDisplayModeIface->AddNumber(DISPLAY_MODE_RAW_BITS, "Raw Bits", "Show raw bits and phases");
	mDisplayModeIface->AddNumber(DISPLAY_MODE_BYTES, "Bytes", "Show bytes");
	mDisplayModeIface->AddNumber(DISPLAY_MODE_WORDS, "Words", "Show words");
	mDisplayModeIface->AddNumber(DISPLAY_MODE_TRANSACTIONS, "Transactions", "Show transactions/words");
	mDisplayModeIface->SetNumber(mDisplayMode);

	AddInterface( mChannelPin1Iface.get() );
	AddInterface( mChannelPin5Iface.get() );
	AddInterface( mDisplayModeIface.get() );

	AddExportOption( 0, "Export as text/csv file" );
	AddExportExtension( 0, "text", "txt" );
	AddExportExtension( 0, "csv", "csv" );

	ClaimChannels();
}

SimpleSerialAnalyzerSettings::~SimpleSerialAnalyzerSettings()
{
}

bool SimpleSerialAnalyzerSettings::SetSettingsFromInterfaces()
{
	if (mChannelPin1Iface->GetChannel() == mChannelPin5Iface->GetChannel()) {
		SetErrorText("Same channel cannot be used for both MAPLE lines");
		return false;
	}

	mChannelPin1 = mChannelPin1Iface->GetChannel();
	mChannelPin5 = mChannelPin5Iface->GetChannel();
	mDisplayMode = (int)mDisplayModeIface->GetNumber();

	ClaimChannels();

	return true;
}

void SimpleSerialAnalyzerSettings::UpdateInterfacesFromSettings()
{
	mChannelPin1Iface->SetChannel( mChannelPin1 );
	mChannelPin5Iface->SetChannel( mChannelPin5 );
	mDisplayModeIface->SetNumber( mDisplayMode );
}

void SimpleSerialAnalyzerSettings::LoadSettings( const char* settings )
{
	SimpleArchive text_archive;
	text_archive.SetString( settings );

	text_archive >> mChannelPin1;
	text_archive >> mChannelPin5;
	text_archive >> mDisplayMode;

	ClaimChannels();
	UpdateInterfacesFromSettings();
}

const char* SimpleSerialAnalyzerSettings::SaveSettings()
{
	SimpleArchive text_archive;

	text_archive << mChannelPin1;
	text_archive << mChannelPin5;
	text_archive << mDisplayMode;

	return SetReturnString( text_archive.GetString() );
}
